    @extends('admin.layouts.app')

    @section('title', 'Data Jatah Cuti')

    @section('content')

        <div class="d-flex justify-content-between align-items-center mb-4">
            <div>
                <h4 class="fw-bold mb-1">Data Jatah Cuti</h4>
                <small class="text-muted">Manajemen jatah cuti</small>
            </div>

            <button class="btn btn-primary btn-sm d-flex align-items-center" data-bs-toggle="modal"
                data-bs-target="#tambahJatah">
                <i class="fas fa-plus me-2"></i>Tambah Data
            </button>
        </div>

        <div class="card shadow-sm border-0">
            <div class="card-body">

                <table class="table table-hover align-middle">
                    <thead class="table-light">
                        <tr>
                            <th>#</th>
                            <th>Karyawan</th>
                            <th>tahun</th>
                            <th>Total Cuti</th>
                            <th class="text-center">Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($jatahCuti as $item)
                            <tr>
                                <td>{{ $loop->iteration }}</td>
                                <td>{{ $item->karyawan->user->nama }}</td>
                                <td>{{ $item->tahun }}</td>
                                <td>{{ $item->jatah }}</td>
                                {{-- <td>
                                    {{ $item->shift->kode }}
                                    <small class="text-muted d-block">
                                        {{ substr($item->shift->jam_masuk, 0, 5) }}
                                        -
                                        {{ substr($item->shift->jam_pulang, 0, 5) }}
                                    </small>
                                </td> --}}

                                {{-- <td>
                                    <span class="badge bg-info text-dark">
                                        {{ $item->role }}
                                    </span>
                                </td> --}}

                                <td class="text-center">
                                    <button data-bs-target="#ubahJatah{{ $item->id }}" data-bs-toggle="modal"
                                        class="btn btn-sm btn-warning">
                                        <i class="fas fa-edit"></i>
                                    </button>
                                    <button class="btn btn-sm btn-danger" data-bs-toggle="modal"
                                        data-bs-target="#hapusJatah{{ $item->id }}">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>

            </div>
            @foreach ($jatahCuti as $item)
                @include('admin.jatah-cuti.edit')
                @include('admin.jatah-cuti.delete')
            @endforeach
        </div>
        @include('admin.jatah-cuti.create')


    @endsection
